//%attributes = {}
// Method: do_ TASKS_JSON_LIST
// 11.09.12, 19:23:59 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// called from: _rc_rpc_ANSWER , see: do_ TASKS_JSON_UPDATE
// https://developers.google.com/google-apps/tasks/v1/reference/tasks/list?hl=fi#examples
// ------------------------------------------------------------
C_LONGINT:C283($1; $do_lJsonAnswer; $2; $do_lJsonParams)
C_TEXT:C284($3; $do_tMethod)
$do_lJsonAnswer:=$1
$do_lJsonParams:=$2
$do_tMethod:=$3

C_LONGINT:C283($do_lIndex; $do_lCount; $do_lJsonAnswerArr; $do_lAnswerObject)
C_TEXT:C284($do_tTag; $do_tTasklist; $do_tUser; $do_tProject)
C_POINTER:C301($do_pFldNumArr; $do_pFldArr)

// COMPILER_do_FLD 

// read from $do_lJsonParams all query params

// *Required Parameters
// tasklist string  Task list identifier.

// *Optional Parameters
// completedMax string  Upper bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional. The default is not to filter by completion date.
// completedMin string  Lower bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional. The default is not to filter by completion date.
// dueMax string  Upper bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The default is not to filter by due date.
// dueMin string  Lower bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The default is not to filter by due date.
// maxResults long  Maximum number of task lists returned on one page. Optional. The default is 100.
// pageToken string  Token specifying the result page to return. Optional.
// showCompleted boolean  Flag indicating whether completed tasks are returned in the result. Optional. The default is True.
// showDeleted boolean  Flag indicating whether deleted tasks are returned in the result. Optional. The default is False.
// showHidden boolean  Flag indicating whether hidden tasks are returned in the result. Optional. The default is False.
// updatedMin string  Lower bound for a task's last modification time (as a RFC 3339 timestamp) to filter by. Optional. The default is not to filter by last modification time.


// query all tasks by params
_json_ JSON($do_lJsonParams; "tasklist"; ->$do_tTag)  // add to query if json param exists
// not in use yet: $do_tTag == Task+ksTab+Pasi+ksTab+myynti = tasklist name / user name / project name
$do_tTasklist:=_str Parse($do_tTag; "|"; 1)
$do_tUser:=_str Parse($do_tTag; "|"; 2)
$do_tProject:=_str Parse($do_tTag; "|"; 3)
If ($do_tTasklist="")
	$do_tTasklist:=_lang Current("Task")  // tasklist name
End if 
If ($do_tUser="")
	$do_tUser:="@"
End if 
If ($do_tProject="")
	$do_tProject:="@"
End if 

_qry Fld(0; do_kCalendar_Name; "="; ->$do_tTasklist; "*"; kFalse; kFalse)
_qry Fld(0; do_kEmployee_id; "="; ->$do_tUser; "&*"; kFalse; kFalse)
$do_lCount:=_qry Fld(0; do_kProject_id; "="; ->$do_tProject; "&"; kFalse; kTrue)

If ($do_lCount>0)
	$do_pFldNumArr:=_fld PtrToFldNumArr(do_kRecord_ID; do_kSummary; do_kChange_ID; do_kInfo)  // do_kProject_id, parent?
	$do_pFldArr:=_fld PtrToFldArr2($do_pFldNumArr)
	//$do_pFldNumArr:=_app_ FldNumArrPtr (do_kTbl)  // return all fields
	//$do_pFldArr:=_app_ FldApArrPtr (do_kTbl)
	_sel SEL_TO_ARR($do_pFldNumArr; $do_pFldArr)
	$do_lCount:=Size of array:C274(do_asSummary)
End if 

//If successful, this method returns a response body with the following structure:
//{
//"kind": "tasks#tasks",
//"etag": string,
//"nextPageToken": string,
//"items": [
//  tasks Resource
//]
//}
_json_ TEXT_ADD($do_lJsonAnswer; "kind"; "tasks#task")
_json_ TEXT_ADD($do_lJsonAnswer; "etag"; "tasks#task")
_json_ TEXT_ADD($do_lJsonAnswer; "nextPageToken"; "tasks#task")

$do_lJsonAnswerArr:=_json_ ArrayCreate
For ($do_lIndex; 1; $do_lCount)
	// COMPILER_do_FLD 
	$do_lAnswerObject:=_json_ ObjectCreate
	_json_ TEXT_ADD($do_lAnswerObject; "kind"; "tasks#task")
	_json_ TEXT_ADD($do_lAnswerObject; "id"; do_atRecord_ID{$do_lIndex})
	_json_ TEXT_ADD($do_lAnswerObject; "etag"; do_atRecord_ID{$do_lIndex})
	_json_ TEXT_ADD($do_lAnswerObject; "title"; do_asSummary{$do_lIndex})
	_json_ TEXT_ADD($do_lAnswerObject; "updated"; _str_ RecodIdToRFC3339(do_asChange_ID{$do_lIndex}))  // RFC3339 = "2012-09-12T04:23:40.215+03:00"
	_json_ TEXT_ADD($do_lAnswerObject; "selfLink"; "")
	_json_ TEXT_ADD($do_lAnswerObject; "parent"; "")
	_json_ TEXT_ADD($do_lAnswerObject; "position"; do_atRecord_ID{$do_lIndex})
	_json_ TEXT_ADD($do_lAnswerObject; "notes"; do_atInfo{$do_lIndex})
	_json_ TEXT_ADD($do_lAnswerObject; "status"; "needsAction")
	_json_ TEXT_ADD($do_lAnswerObject; "due"; "")  // RFC3339
	_json_ TEXT_ADD($do_lAnswerObject; "completed"; "")  // RFC3339
	_json_ BOOL_ADD($do_lAnswerObject; "deleted"; False:C215)
	_json_ BOOL_ADD($do_lAnswerObject; "hidden"; False:C215)
	_json_ TEXT_ADD($do_lAnswerObject; "links"; "[]")
	_json_ ARRAY_ITEM_ADD($do_lJsonAnswerArr; $do_lAnswerObject)  // now $do_lAnswerObject belongs to $do_lJsonAnswerArr and can't be used anymore
End for 

_json_ OBJECT_ADD($do_lJsonAnswer; "items"; $do_lJsonAnswerArr)  // now $do_lJsonAnswerArr belongs to $do_lJsonAnswer and can't be used anymore
_json_ TEXT_ADD($do_lJsonAnswer; "result"; $do_tMethod+" ok")

//  Goole tasks record structure
//  /* https:// developers.google.com/google-apps/tasks/v1/reference/tasks?hl=fi
//   *
//   Property  Value   Description
//   ---------------------------------
// - kind  string  Type of the resource. This is always "tasks#task".
// - id   string  Task identifier.
// - etag  etag   ETag of the resource.
// - title  string  Title of the task.
// - updated   datetime Last modification time of the task (as a RFC 3339 timestamp).
// - selfLink  string  URL pointing to this task. Used to retrieve, update, or delete this task.
// - parent   string  Parent task identifier. This field is omitted if it is a top-level task. This field is read-only. Use the "move" method to move the task under a different parent or to the top level.
// 
// - position  string String indicating the position of the task among its sibling tasks under the same parent task or at the top level. 
//   If this string is greater than another task's corresponding position string according to lexicographical ordering, the task is 
//   positioned after the other task under the same parent task (or at the top level). This field is read-only. Use the "move" method to move the task to another position.
// 
// - notes  string  Notes describing the task. Optional.
// - status   string  Status of the task. This is either "needsAction" or "completed".
// - due   datetime Due date of the task (as a RFC 3339 timestamp). Optional.
// - completed  datetime Completion date of the task (as a RFC 3339 timestamp). This field is omitted if the task has not been completed.
// 
// - deleted   boolean  Flag indicating whether the task has been deleted. The default if False.
// - hidden   boolean  Flag indicating whether the task is hidden. This is the case if the task had been - marked  completed when the task list was last cleared. The default is False. This field is read-only.
// 
// - links[]   list   Collection of links. This collection is read-only.
// - .type   string Type of the link, e.g. "email".
// - .description string The description. In HTML speak: Everything between <a> and </a>.
// - .link   string The URL.
// 
// RFC 3339 timestamp format example: 20100908T070000Z
// https:// github.com/tardate/rfc3339date.js
//  ( http:// tardate.blogspot.com/2010/10/rfc-3339-iso-8601-dates-in-javascript.html )
